import 'bulma/css/bulma.min.css'

type ModalProps = {
    show: boolean
    word: string
    onClose: () => void
}

function WordModal(props: ModalProps) {
    let classNames = 'modal'
    if (props.show) {
        classNames += ' is-active'
    }

    return (
        <div className={classNames}>
            <div className="modal-background"></div>
            <div className="modal-card">
                <header className="modal-card-head">
                    <p className="modal-card-title">Första bokstaven i ordet...</p>
                    <button className="delete" aria-label="close" onClick={props.onClose}></button>
                </header>
                <section className="modal-card-body">
                    <h1 className="title" style={{textAlign: 'center'}}>{props.word}</h1>
                    <div className="title" style={{textAlign: 'center', fontSize: '8rem'}}>
                        {props.word.at(0)?.toUpperCase()}
                    </div>
                </section>
            </div>
        </div>
    )
}

export default WordModal